
REM     *****************************************************************
REM     * Written by Fredric Rice                                       *
REM     *                                                               *
REM     * Date started: 27/Mar/84,   Date last update: 04/Mar/86.       *
REM     *                                                               *
REM     * Copyright Stargoat Industries, 1984 through 2002, All Rights  *
REM     * are reserved.  Distribution and duplication of this product   *
REM     * is granted for noon-commercial use provided the executable,   *
REM     * source code, and documentation is not altered in any way.     *
REM     *                                                               *
REM     * For updates and information contact Fredric L. Rice at The    *
REM     * Skeptic Tank, frice@skeptictank.org                           *
REM     *                                                               *
REM     *****************************************************************

        integer line.control.register, line.status.register
        integer receive.buffer, transmit.buffer, dlab.value.on
        integer dlab.value.off, baud.rate.lsb, baud.rate.msb
        integer modem.control.register, byte, baud.lsb, baud.msb
        integer at.point, option, loop, timeout, baud.assignment

        serial.number$ = "IBM0001"

rem     *****************************************************************
rem     * Receive a character from the port selected.                   *
rem     *                                                               *
rem     *****************************************************************

def     receive
        if (inp(line.status.register) and 1) = 1 then \
           byte = inp(receive.buffer): return else \
           byte = 0: return
fend

rem     *****************************************************************
rem     * Here is the transmit of a byte routine.                       *
rem     *                                                               *
rem     *****************************************************************

def     transmit
continue.to.transmit:
        if (inp(line.status.register) and 32) <> 32 then \
           goto continue.to.transmit else \
           out transmit.buffer, byte: return
fend

rem     *****************************************************************
rem     * Here we initialize the communications port serial board. If   *
rem     * the com port is zero, the secondary port is used, else the    *
rem     * com port is one, so the primary one is selected.              *
rem     *                                                               *
rem     *****************************************************************

def     initialization.routine
        line.control.register = 2fbh + (port.assignment * 100h)
        line.status.register = 2fdh + (port.assignment * 100h)
        receive.buffer = 2f8h + (port.assignment * 100h)
        transmit.buffer = 2f8h + (port.assignment * 100h)
        dlab.value.on = 83h
        dlab.value.off = 3h
        baud.rate.lsb = 2f8h + (port.assignment * 100h)
        baud.rate.msb = 2f9h + (port.assignment * 100h)
        modem.control.register = 2fch + (port.assignment * 100h)

rem     *****************************************************************
rem     * Reset the various things for communication by setting bits    *
rem     * On or Off in the various addresses.                           *
rem     * Modem gets data terminal ready and request to send active     *
rem     *                                                               *
rem     *****************************************************************

        out line.control.register, 0
        out line.status.register, 60h
        out modem.control.register, 3

rem     *****************************************************************
rem     * Set the dlab register on with 8 data bits, 1 stop, no parity  *
rem     *                                                               *
rem     *****************************************************************

        out line.control.register, dlab.value.on

rem     *****************************************************************
rem     * The most significant and least significant bytes for baud rate*
rem     * 300 baud is 1, 92                                             *
rem     * 600 baud is 0, 192                                            *
rem     * 1200 baud is 0, 96                                            *
rem     * 2400 baud is 0, 48                                            *
rem     * 4800 baud is 0, 24                                            *
rem     * 9600 baud is 0, 12                                            *
rem     *                                                               *
rem     *****************************************************************

rem     *****************************************************************
rem     * Set the baud rate to requested baud.                          *
rem     *                                                               *
rem     *****************************************************************
 
        baud.lsb = 0: baud.msb = 0
        if baud.rate$ =  "300" then baud.msb = 1: baud.lsb = 128
        if baud.rate$ =  "600" then baud.msb = 0: baud.lsb = 192
        if baud.rate$ = "1200" then baud.msb = 0: baud.lsb = 96
        if baud.rate$ = "2400" then baud.msb = 0: baud.lsb = 48
        if baud.rate$ = "4800" then baud.msb = 0: baud.lsb = 24
        if baud.rate$ = "9600" then baud.msb = 0: baud.lsb = 12

        out baud.rate.lsb, baud.lsb
        out baud.rate.msb, baud.msb

rem     *****************************************************************
rem     * Turn the dlab off.                                            *
rem     *                                                               *
rem     *****************************************************************

        out line.control.register, dlab.value.off
fend

rem     *****************************************************************
rem     * Open the ibmfluke.dat file and read what the com port is      *
rem     * assigned to. If the file does not exist, create it.           *
rem     *                                                               *
rem     * Also parse the command$ into various factors, determine is a  *
rem     * file name is valid or not, Append a .FLK if none is offered.  *
rem     * If the file extention type is not .FLK, give an error message *
rem     * If a value is offered from the command line, append this      *
rem     * value into the option variable and execute without asking     *
rem     * for the value again at the menu input.                        *
rem     *                                                               *
rem     *****************************************************************

        file.name$ = ucase$(command$): print: print

        if match(",", file.name$, 1) <> 0 then old.file.name$ = file.name$: \
           at.point = match(",", file.name$, 1): \
           file.name$ = left$(file.name$, at.point - 1): \
           option = val(mid$(old.file.name$, at.point + 1, 1)) else \
           option = 0

        if len(file.name$) = 0 then \
           print "Enter the file name with the transfer request:": \
           print "Example:  FLUKE MEMTEST [return]": stop

        if 0 = match(".", file.name$, 1) then \
           file.name$ = file.name$ + ".FLK"

        if 0 = match(".FLK", file.name$, 1) then \
           print "Invalid file name. Must have .FLK extention": stop

        if end #1 then create.the.com.data.file
        open "IBMFLUKE.DAT" as 1
        read #1; assignment$
        read #1; baud.rate$: close 1
        port.assignment = val(assignment$)
        goto main.menu.setup

create.the.com.data.file:
        create "IBMFLUKE.DAT" as 1: print using "&"; #1; "1"
        print using "&"; #1; "2400": close 1
        port.assignment = 1: assignment$ = "1": baud.rate$ = "2400"

rem     *****************************************************************
rem     * Here we will be setting up the port assignment and addresses  *
rem     *                                                               *
rem     *****************************************************************

main.menu.setup:
        if port.assignment <> 1 then port.assignment = 0
        call initialization.routine

rem     *****************************************************************
rem     * Here is where the menu gets printed to the screen.            *
rem     *                                                               *
rem     *****************************************************************

main.menu:
        cls$ = chr$(13) + string$(24, chr$(10)): print cls$
        print tab(60);"Port:    :COM";assignment$
        print tab(60);"File:    ";file.name$
        print tab(60);"Serial:  ";serial.number$
        print tab(60);"Baud:    ";baud.rate$
        for loop = 1 to 4: print: next loop
        print tab(20);"1... Transfer workspace to Fluke": print
        print tab(20);"2... Transfer workspace to IBM": print
        print tab(20);"3... Change :COM port assignment": print
        print tab(20);"4... Transfer to Fluke when called": print
        print tab(20);"5... Change Baud rate": print
        for loop = 1 to 5: print: next loop
        print tab(20);"Please enter your selection:";
        if option <> 0 then goto we.have.the.option
        while not constat%
        wend
        option = val(chr$(conchar%))

we.have.the.option:
        if option = 5 then goto change.the.baud.rate
        if option = 4 then goto transfer.to.fluke
        if option = 3 then goto ask.for.port.assignment
        if option = 2 then goto transfer.to.ibm
        if option = 1 then goto transfer.to.fluke
        if option <> 0 then goto main.menu
        print cls$: print "Operation ending": stop

rem     *****************************************************************
rem     * Here we have requested the com port assignment to be changed  *
rem     *                                                               *
rem     *****************************************************************

ask.for.port.assignment:
        print cls$
        print "Do you want :COM port assignment 1 or 2: ";
        while not constat%
        wend
        port.assignment = val(chr$(conchar%))
        if port.assignment = 1 or port.assignment = 2 then goto this.is.ok
        goto ask.for.port.assignment

rem     *****************************************************************
rem     * When port assignment is 0, the secondary address is used, if  *
rem     * the port assignment is 1, the address used is the primary one *
rem     * We do this by adding 100h to the address if the primary gets  *
rem     * requested.                                                    *
rem     *                                                               *
rem     *****************************************************************

this.is.ok:
        if port.assignment = 1 then assignment$ = "1" else \
           assignment$ = "2"

        open "IBMFLUKE.DAT" as 1: option = 0
        print using "&"; #1; assignment$
        print using "&"; #1; baud.rate$: close 1
        call initialization.routine: goto main.menu.setup

rem     *****************************************************************
rem     * Here we will transfer a workspace to the ibm from the fluke   *
rem     * We check to make certain the file does not exist yet.         *
rem     *                                                               *
rem     *****************************************************************

transfer.to.ibm:
        if end #2 then continue.with.transfer
        open file.name$ as 2: print cls$
        print "File: ";file.name$;" is already on your disk!": stop

continue.with.transfer:
        create file.name$ as 2
        data.buffer$ = string$(30000, chr$(0))
        data.buffer% = 2 + sadd(data.buffer$)
        old.buffer% = data.buffer%: timeout = 0
        print cls$: print "Waiting for data"
        while byte = 0
           call receive
        wend
        goto plug.this.byte

get.all.of.the.data:
        call receive

plug.this.byte:
        if byte <> 0 then poke data.buffer%, byte: \
           data.buffer% = data.buffer% + 1: \
           timeout = 0: goto get.all.of.the.data

        timeout = timeout + 1
        if timeout < 22000 then goto get.all.of.the.data

        print cls$: print "Wait one moment, please... Saving";
        print (data.buffer% - old.buffer%);"bytes"
        for loop = old.buffer% to data.buffer%
           put 2, peek(loop)
        next loop
        print "File has been transfered and saved.": close 2: stop

rem     *****************************************************************
rem     * Here we will transfer a workspace to the fluke from the ibm   *
rem     * We open the file to see if it is a valid file first.          *
rem     *                                                               *
rem     *****************************************************************

transfer.to.fluke:
        if end #2 then unable.to.locate.the.file
        open file.name$ as 2: goto the.ibm.file.is.open

unable.to.locate.the.file:
        print cls$
        print "I am unable to locate file: ";file.name$: stop

the.ibm.file.is.open:
        print cls$
        print "Sending workspace: "; file.name$
        if end #2 then end.of.ibm.file.located

        if option = 4 then \
           print cls$: \
           print "I am waiting for you to hit AUX I/F, READ, and YES": \
           print "on the Fluke 9010a keyboard before I transfer the file": \
           while byte = 0: \
              call receive: \
           wend

read.in.an.ibm.record:
        read #2; line record$: record$ = record$ + chr$(13) + chr$(10)
           for loop = 1 to len(record$)
           byte = asc(mid$(record$, loop, 1))
           call transmit: bc = bc + 1
        next loop
        goto read.in.an.ibm.record

end.of.ibm.file.located:
        close 2: print cls$
        print "File: ";file.name$;" has been sent to the Fluke"
        print "Total of";bc;"bytes transmitted.": stop

rem     *****************************************************************
rem     * Here we will allow the operator to change the baud rate       *
rem     *                                                               *
rem     *****************************************************************

change.the.baud.rate:
        print cls$
        print tab(20); "1 ... 300 baud": print
        print tab(20); "2 ... 600 baud": print
        print tab(20); "3 ... 1200 baud": print
        print tab(20); "4 ... 2400 baud": print
        print tab(20); "5 ... 4800 baud": print
        print tab(20); "6 ... 9600 baud": print
        print: print: print: print
        print "Enter selection above, or [ENTER] to abort: ";
        while not constat%
        wend
        baud.assignment = val(chr$(conchar%))
        if baud.assignment < 1 or baud.assignment > 6 then goto main.menu

        if baud.assignment = 1 then baud.rate$ = "300"
        if baud.assignment = 2 then baud.rate$ = "600"
        if baud.assignment = 3 then baud.rate$ = "1200"
        if baud.assignment = 4 then baud.rate$ = "2400"
        if baud.assignment = 5 then baud.rate$ = "4800"
        if baud.assignment = 6 then baud.rate$ = "9600"

        open "IBMFLUKE.DAT" as 1: call initialization.routine
        print using "&"; #1; assignment$: option = 0
        print using "&"; #1; baud.rate$: close 1: goto main.menu

